static char *_desc="\
/*
 *	m2_rmmount.c
 *
 *	alternative /usr/sbin/rmmount
 *
 *	If env VOLUME_MEDIATYPE is set to \"rmscsi\",
 *	delete \":c\" from /etc/mnttab, and then proceed to
 *	original rmmount command.
 *	This is needed to make volrmmount and eject useful.
 *
 */
";
static char *_rcsid = "$Id: m2_rmmount.c,v 1.2 2000-02-12 01:50:39+09 kabe Exp $";

#include <stdio.h>
#include <unistd.h>	/*lockf*/
#include <stdlib.h>	/*getenv*/
#include <strings.h>	/*strdup*/
#include <sys/param.h>	/*MAXPATHLEN*/

#include <sys/mnttab.h>

#ifndef MNTTAB
#define MNTTAB "/etc/mnttab"
#endif
#ifndef MNTTAB_LOCK
#define MNTTAB_LOCK "/etc/.mnttab.lock"
#endif
#ifndef MNT_LINE_MAX
#define MNT_LINE_MAX 1024
#endif

#ifndef SVX
#define SVX ".dist"
#endif

#define REAL_RMMOUNT	"/usr/sbin/rmmount" SVX

/*
 * Because eject(1) and volrmmount(1) passes *different* values for 
 * VOLUME_MEDIATYPE env (isn't that a bug?), multiple matching is needed.
 * eject(1) always passes "rmscsi", but 
 * volrmmount(1) could pass "zip" "mo" "jaz" or whatever 
 * taken from the symname of the "use" line in /etc/vold.conf.
 * (For standard settings it will be always "rmscsi" tho)
 */
char *rmscsi_mediatypes[] = {
	"rmscsi",
	"mo", "zip","jaz",
	NULL
};

main(int argc, char *argv[])
{
	int	i,s;
	char	*volume_mediatype;	/* "rmscsi" */
	char	*volume_path;	/* "/vol/dev/dsk/c0t4d0/unlabeled" */
	char	*volume_action;	/* "eject" */
	FILE	*fmnt, *fmnt_lock;
	struct mnttab mntents[MNT_LINE_MAX];

	/* select `eject rmscsi' (what about notify event?) */
	volume_mediatype = getenv("VOLUME_MEDIATYPE");
	volume_action    = getenv("VOLUME_ACTION");
	volume_path      = getenv("VOLUME_PATH");
	if (!volume_mediatype || !volume_action /*|| !volume_path*/) {
		goto real_rmmount;
	}
	for (i=0; ; i++) {
		if (!rmscsi_mediatypes[i]) goto real_rmmount;
	
		if (!strcasecmp(volume_mediatype, rmscsi_mediatypes[i])) {
			/* Got mediatype match.
			 *
			 * Rewrite VOLUME_MEDIATYPE to "rmscsi",
			 * to make "ident" line in rmmount.conf match.
			 * Without this, "volrmmount -i zip" may not work
			 * without adding "zip" to "ident pcfs" line.
			 *
			 * This is ugly but I guess it's a flaw in volrmmount
			 * implementation; it doesn't contact vold 
			 * (eject(1) does).
			 */
			putenv("VOLUME_MEDIATYPE=rmscsi");
			break;
		}
	}
	if (!!strcmp(volume_action, "eject")) {
		goto real_rmmount;
	}

	/* Eject. */
	/* now, drill out ":c" from /etc/mnttab ... */

	fmnt_lock = fopen(MNTTAB_LOCK, "w");
	if (!fmnt_lock) { exit(1); }
	lockf(fileno(fmnt_lock), F_LOCK, 0);

	/* read in the current mnttab */
	fmnt = fopen( MNTTAB, "r+");
	if (!fmnt) { exit(1); }
	lockf(fileno(fmnt), F_LOCK, 0);

	/* read all, and replace the new entry */
	for(i=0; (s = getmntent(fmnt, &mntents[i])) == 0; i++ ) {
		/*putmntent(stdout, &mntents[i]);/**/
		if (!strncmp(mntents[i].mnt_special, volume_path, strlen(volume_path)) ) {
			char	*p;
			p = mntents[i].mnt_special + strlen(mntents[i].mnt_special);
			/* retreat to ":c"-less name */
			if (p[-2]==':' && p[-1]=='c')
				p[-2] = '\0';
		}
		/* save the structure */
		mntents[i].mnt_special = strdup(mntents[i].mnt_special);
		mntents[i].mnt_mountp  = strdup(mntents[i].mnt_mountp);
		mntents[i].mnt_fstype  = strdup(mntents[i].mnt_fstype);
		mntents[i].mnt_mntopts = strdup(mntents[i].mnt_mntopts);
		mntents[i].mnt_time    = strdup(mntents[i].mnt_time);
	}
	mntents[i].mnt_special = NULL;	/*bookkeeper*/

	if ( s>0 ) {
		fprintf(stderr,"Invalid line in " MNTTAB ", not touched\n");
		exit(s);
	}

	/* rewind mnttab and rewrite it */
	rewind(fmnt);
	for(i=0; mntents[i].mnt_special; i++) {
		putmntent(fmnt, &mntents[i]);
	}

	fflush(fmnt);
	ftruncate(fileno(fmnt), ftello(fmnt));	/*correct?*/

	fclose(fmnt);
	fclose(fmnt_lock);

real_rmmount:
	execv(REAL_RMMOUNT, argv);
	/*NOTREACHED*/
	fprintf(stderr,"Fatal error: cannot exec %s\n", REAL_RMMOUNT);

	/* Real rmmount could fail if the mountpoint was busy; 
	 * this leaves /etc/mnttab in modified state, which 
	 * the entry is still there but with ":c" stripped off.
	 * It won't affect the next eject but could be confusing to human.
	 */
}
