static char *_desc = "
/*
 *	m2_pcfs_mount.c
 *
 *	Append \":c\" to device file name string,
 *	weed out \"nosuid\" option, and exec original mount.
 *
 */
";
static char *_rcsid = "$Id: m2_pcfs_mount.c,v 1.1 2000-01-29 13:15:59+09 kabe Exp $";

#include <stdio.h>
#include <sys/param.h>	/*MAXPATHLEN*/
#include <strings.h>

#ifndef SVX
#define SVX ".dist"
#endif

#define REAL_PCFS_MOUNT	"/usr/lib/fs/pcfs/mount" SVX

int
main(int argc, char *argv[])
{
	int	i;
	char	buf[MAXPATHLEN];
#ifndef ALWAYS_ADD_C
	if (!getenv("VOLUME_ACTION")) goto goreal;
#endif
	/* append ":c" to device file name */
	strcpy(buf, argv[argc-2]);
	strcat(buf, ":c");
	argv[argc-2] = buf;

	/* weed out invalid options added by rmmount */
	/* rmmount seems to add "-o nosuid" for filesystems it doesn't know */
	for (i=1; i<argc; i++) {
		char *p;
		if (!strcmp(argv[i], "-o") &&
		    i+1<argc && (p=strstr(argv[i+1], "nosuid")) )
		{
			/* weed "nosuid" */
			for ( ; (*p = *(p+6)); p++) ;
			/* if option arg disappered, delete "-o" also */
			if (!argv[i+1][0]) {
				int	s;
				for ( s=i+2; s<=argc; s++) argv[s-2]=argv[s];
				argc -= 2;
				i--; continue;
			}
		}
	}
goreal:
	return execv(REAL_PCFS_MOUNT, argv);
}
