static char *_desc = "
/*
 *	m1_pcfs_mount.c
 *
 *	alternative /usr/lib/fs/pcfs/mount
 *
 *	If env VOLUME_MEDIATYPE is set to \"rmscsi\",
 *	append \":c\" to device file param and invoke the original mount.
 *	Then delete \":c\" from /etc/mnttab.
 *	This is needed to make volrmmount and eject useful.
 *
 */
";
static char *_rcsid = "$Id: m1_pcfs_mount.c,v 1.1 2000-01-29 13:15:34+09 kabe Exp $";

#include <stdio.h>
#include <unistd.h>	/*lockf*/
#include <stdlib.h>	/*getenv*/
#include <strings.h>	/*strdup*/
#include <sys/param.h>	/*MAXPATHLEN*/
#include <sys/wait.h>

#include <sys/mnttab.h>

#ifndef MNTTAB
#define MNTTAB "/etc/mnttab"
#endif
#ifndef MNTTAB_LOCK
#define MNTTAB_LOCK "/etc/.mnttab.lock"
#endif
#ifndef MNT_LINE_MAX
#define MNT_LINE_MAX 1024
#endif

#ifndef SVX
#define SVX ".dist"
#endif

#define REAL_PCFS_MOUNT "/usr/lib/fs/pcfs/mount" SVX

int
main(int argc, char *argv[])
{
	int	i,s;
	char	*volume_mediatype;	/* "rmscsi" */
	FILE	*fmnt, *fmnt_lock;
	struct mnttab mntents[MNT_LINE_MAX];
	char	buf[MAXPATHLEN];

	volume_mediatype = getenv("VOLUME_MEDIATYPE");
	if (!volume_mediatype) {
		/* not invoked from vold/volrmmount; */
		/* invoke mount and exit */
		execv(REAL_PCFS_MOUNT, argv);
		fprintf(stderr,"Fatal error: cannot exec %s\n", REAL_PCFS_MOUNT);
		exit(1);
	}

	/* append ":c" to device name */

	/* sanity check */
	if (argv[argc-2][0] != '/') {
		fprintf(stderr,"Special file not an absolute path?\n");
		exit(1);
	}

	strcpy(buf, argv[argc-2]);
	strcat(buf,":c");

	/* and invoke mount(1) */
	if (!fork()) {
		/* child */
		argv[argc-2] = buf;
		execv(REAL_PCFS_MOUNT, argv);
		fprintf(stderr,"Fatal error: cannot exec %s\n", REAL_PCFS_MOUNT);
		exit(1);
	} else {
		/* parent */
		/* wait for mount to complete.
		   check the return, and exit if non-zero */
		wait(&s);
		if (!WIFEXITED(s) || WEXITSTATUS(s)!=0) {
			/* mount(1) will put enough error messages */
			return WEXITSTATUS(s);
		}
	}

	fmnt_lock = fopen(MNTTAB_LOCK, "w");
	if (!fmnt_lock) { exit(1); }
	lockf(fileno(fmnt_lock), F_LOCK, 0);

	/* read in the current mnttab */
	fmnt = fopen( MNTTAB, "r+");
	if (!fmnt) { exit(1); }
	lockf(fileno(fmnt), F_LOCK, 0);

	/* read all, and replace the new entry */
	for(i=0; (s = getmntent(fmnt, &mntents[i])) == 0; i++ ) {
		/*putmntent(stdout, &mntents[i]);/**/
		if (!strcmp(mntents[i].mnt_special, buf)) {
			/* retreat to ":c"-less name */
			*strstr(mntents[i].mnt_special, ":c") = '\0';
		}
		/* save the structure */
		mntents[i].mnt_special = strdup(mntents[i].mnt_special);
		mntents[i].mnt_mountp  = strdup(mntents[i].mnt_mountp);
		mntents[i].mnt_fstype  = strdup(mntents[i].mnt_fstype);
		mntents[i].mnt_mntopts = strdup(mntents[i].mnt_mntopts);
		mntents[i].mnt_time    = strdup(mntents[i].mnt_time);
	}
	mntents[i].mnt_special = NULL;	/*bookkeeper*/

	if ( s>0 ) {
		/* invalid line in mnttab found */
		fprintf(stderr,"Invalid line in %s, not touched\n", MNTTAB);
		exit(s);
	}

	/* rewind mnttab and rewrite it */
	rewind(fmnt);
	for(i=0; mntents[i].mnt_special; i++) {
		putmntent(fmnt, &mntents[i]);
	}

	fflush(fmnt);
	ftruncate(fileno(fmnt), ftello(fmnt));	/*correct?*/

	fclose(fmnt);
	fclose(fmnt_lock);

	return 0;
}
